using System;
using System.Collections.Generic;
using System.Linq;

public class ResavacTrke
{
    public static void Main(string[] args)
    {
        string unosN = Console.ReadLine();
        if (!int.TryParse(unosN, out int N))
        {
            return;
        }

        Dictionary<long, long> countU = new Dictionary<long, long>();
        Dictionary<long, long> countV = new Dictionary<long, long>();

        for (int i = 0; i < N; i++)
        {
            string line = Console.ReadLine();
            if (string.IsNullOrEmpty(line)) continue;
            
            string[] parts = line.Split(' ');
            
            if (parts.Length != 2 || 
                !long.TryParse(parts[0], out long xi) || 
                !long.TryParse(parts[1], out long yi))
            {
                continue;
            }

            long u = xi + yi;
            long v = xi - yi;

            if (countU.ContainsKey(u))
            {
                countU[u]++;
            }
            else
            {
                countU[u] = 1;
            }

            if (countV.ContainsKey(v))
            {
                countV[v]++;
            }
            else
            {
                countV[v] = 1;
            }
        }

        long totalGreetings = 
            countU.Values.Where(k => k >= 2).Sum(k => k * (k - 1)) +
            countV.Values.Where(k => k >= 2).Sum(k => k * (k - 1));

        Console.WriteLine(totalGreetings);
    }
}